/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.resolution.ConstraintResolutionGui;
import gg.essential.elementa.constraints.resolution.ConstraintResolver;
import gg.essential.elementa.constraints.resolution.ConstraintResolverV2;
import gg.essential.elementa.constraints.resolution.ResolverNode;
import gg.essential.elementa.effects.ScissorEffect;
import gg.essential.elementa.utils.InvalidUsageKt;
import gg.essential.elementa.utils.OptionsKt;
import gg.essential.universal.UChat;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.UResolution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\t\u0018\u0000 P2\u00020\u0001:\u0001PB\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0001J\b\u0010+\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020)H\u0016J\b\u0010-\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u00102\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0016J\u0015\u00103\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020)H\u0007J\u000e\u00105\u001a\u00020)2\u0006\u0010/\u001a\u000200J\u000e\u00106\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0001J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u000208H\u0016J\b\u0010;\u001a\u000208H\u0016J\b\u0010<\u001a\u000208H\u0016J\b\u0010=\u001a\u000208H\u0016J\u0018\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u0002082\u0006\u0010@\u001a\u000208H\u0016J&\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000eJ\u0018\u0010F\u001a\u00020)2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0003H\u0016J \u0010J\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010K\u001a\u00020)H\u0016J\u0010\u0010L\u001a\u00020)2\u0006\u0010M\u001a\u00020\u000eH\u0016J\u000e\u0010N\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0001J\u0006\u0010O\u001a\u00020)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000Ra\u0010\f\u001aI\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u000b\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0004\u0018\u00010\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001f\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006Q"}, d2={"Lgg/essential/elementa/components/Window;", "Lgg/essential/elementa/UIComponent;", "animationFPS", "", "(I)V", "version", "Lgg/essential/elementa/ElementaVersion;", "(Lgg/essential/elementa/ElementaVersion;I)V", "getAnimationFPS", "()I", "cancelDrawing", "", "clickInterceptor", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "mouseX", "mouseY", "button", "getClickInterceptor$Elementa", "()Lkotlin/jvm/functions/Function3;", "setClickInterceptor$Elementa", "(Lkotlin/jvm/functions/Function3;)V", "componentRequestingFocus", "currentMouseButton", "floatingComponents", "", "<set-?>", "focusedComponent", "getFocusedComponent", "()Lgg/essential/elementa/UIComponent;", "hoveredFloatingComponent", "getHoveredFloatingComponent", "setHoveredFloatingComponent", "(Lgg/essential/elementa/UIComponent;)V", "systemTime", "", "getVersion$Elementa", "()Lgg/essential/elementa/ElementaVersion;", "addFloatingComponent", "", "component", "afterInitialization", "animationFrame", "dealWithFocusRequests", "doDraw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "doMouseClick", "draw", "drawEmbedded", "drawEmbedded$Elementa", "drawFloatingComponents", "focus", "getBottom", "", "getHeight", "getLeft", "getRight", "getTop", "getWidth", "hitTest", "x", "y", "isAreaVisible", "left", "top", "right", "bottom", "keyType", "typedChar", "", "keyCode", "mouseClick", "mouseRelease", "mouseScroll", "delta", "removeFloatingComponent", "unfocus", "Companion", "Elementa"})
@SourceDebugExtension(value={"SMAP\nWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Window.kt\ngg/essential/elementa/components/Window\n+ 2 ElementaVersion.kt\ngg/essential/elementa/ElementaVersion\n*L\n1#1,411:1\n105#2,6:412\n*S KotlinDebug\n*F\n+ 1 Window.kt\ngg/essential/elementa/components/Window\n*L\n58#1:412,6\n*E\n"})
public final class Window
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ElementaVersion version;
    private final int animationFPS;
    private long systemTime;
    private int currentMouseButton;
    @NotNull
    private List<UIComponent> floatingComponents;
    @Nullable
    private UIComponent hoveredFloatingComponent;
    @Nullable
    private UIComponent focusedComponent;
    @Nullable
    private UIComponent componentRequestingFocus;
    private boolean cancelDrawing;
    @Nullable
    private Function3<? super Double, ? super Double, ? super Integer, Boolean> clickInterceptor;
    @NotNull
    private static final ConcurrentLinkedQueue<Function0<Unit>> renderOperations = new ConcurrentLinkedQueue();

    @JvmOverloads
    public Window(@NotNull ElementaVersion version, int animationFPS) {
        Intrinsics.checkNotNullParameter((Object)version, "version");
        this.version = version;
        this.animationFPS = animationFPS;
        this.systemTime = -1L;
        this.currentMouseButton = -1;
        this.floatingComponents = new ArrayList();
        super.setParent(this);
    }

    public /* synthetic */ Window(ElementaVersion elementaVersion, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 244;
        }
        this(elementaVersion, n);
    }

    @NotNull
    public final ElementaVersion getVersion$Elementa() {
        return this.version;
    }

    public final int getAnimationFPS() {
        return this.animationFPS;
    }

    @Nullable
    public final UIComponent getHoveredFloatingComponent() {
        return this.hoveredFloatingComponent;
    }

    public final void setHoveredFloatingComponent(@Nullable UIComponent uIComponent) {
        this.hoveredFloatingComponent = uIComponent;
    }

    @Nullable
    public final UIComponent getFocusedComponent() {
        return this.focusedComponent;
    }

    @Nullable
    public final Function3<Double, Double, Integer, Boolean> getClickInterceptor$Elementa() {
        return this.clickInterceptor;
    }

    public final void setClickInterceptor$Elementa(@Nullable Function3<? super Double, ? super Double, ? super Integer, Boolean> function3) {
        this.clickInterceptor = function3;
    }

    @Deprecated(message="Add ElementaVersion as the first argument to opt-in to improved behavior.")
    @JvmOverloads
    public Window(int animationFPS) {
        this(ElementaVersion.Companion.getV0$Elementa(), animationFPS);
    }

    public /* synthetic */ Window(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 244;
        }
        this(n);
    }

    @Override
    public void afterInitialization() {
        super.afterInitialization();
        Companion.enqueueRenderOperation(afterInitialization.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        ElementaVersion this_$iv = this.version;
        boolean $i$f$enableFor = false;
        ElementaVersion prevVersion$iv = ElementaVersion.Companion.getActive();
        ElementaVersion.Companion.setActive(this_$iv);
        try {
            boolean bl = false;
            this.doDraw(matrixStack);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            ElementaVersion.Companion.setActive(prevVersion$iv);
        }
    }

    private final void doDraw(UMatrixStack matrixStack) {
        if (this.cancelDrawing) {
            return;
        }
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        long startTime = System.nanoTime();
        Iterator<Function0<Unit>> iterator2 = renderOperations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "renderOperations.iterator()");
        Iterator<Function0<Unit>> it = iterator2;
        while (it.hasNext() && System.nanoTime() - startTime < TimeUnit.MILLISECONDS.toNanos(5L)) {
            it.next().invoke();
            it.remove();
        }
        if (this.systemTime == -1L) {
            this.systemTime = System.currentTimeMillis();
        }
        try {
            if (System.currentTimeMillis() - this.systemTime > TimeUnit.SECONDS.toMillis(5L)) {
                this.systemTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(5L);
            }
            long target = System.currentTimeMillis() + (long)(1000 / this.animationFPS);
            int animationFrames = (int)(target - this.systemTime) * this.animationFPS / 1000;
            int n = RangesKt.coerceAtMost(animationFrames, RangesKt.coerceAtLeast(this.animationFPS / 30, 1));
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it2 = n2++;
                boolean bl = false;
                this.animationFrame();
                this.systemTime += (long)(1000 / this.animationFPS);
            }
            this.hoveredFloatingComponent = null;
            Pair<Float, Float> pair = this.getMousePosition();
            float mouseX = ((Number)pair.component1()).floatValue();
            float mouseY = ((Number)pair.component2()).floatValue();
            for (UIComponent component2 : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
                if (!component2.isPointInside(mouseX, mouseY)) continue;
                this.hoveredFloatingComponent = component2;
                break;
            }
            this.mouseMove(this);
            this.beforeDraw(matrixStack);
            super.draw(matrixStack);
        }
        catch (Throwable e) {
            ConstraintResolutionGui constraintResolutionGui;
            String string;
            String guiName;
            String string2;
            this.cancelDrawing = true;
            Class<?> clazz = UMinecraft.getCurrentScreenObj();
            if ((clazz != null && (clazz = clazz.getClass()) != null ? clazz.getSimpleName() : (string2 = null)) == null) {
                string2 = guiName = "<unknown>";
            }
            if (e instanceof StackOverflowError) {
                string = "Elementa: Cyclic constraint structure detected!";
                System.out.println((Object)string);
                string = "If you are a developer, set the environment variable \"elementa.dev=true\" to assist in debugging the issue.";
                System.out.println((Object)string);
            } else {
                string = "Elementa: encountered an error while drawing a GUI";
                System.out.println((Object)string);
            }
            String animationFrames = "Gui name: " + guiName;
            System.out.println((Object)animationFrames);
            e.printStackTrace();
            ScissorEffect.Companion.setCurrentScissorState(null);
            GL11.glDisable(3089);
            if (e instanceof StackOverflowError && OptionsKt.getElementaDev()) {
                List<ResolverNode> list;
                string = System.getProperty("elementa.dev.cycle_resolver", "2");
                if (Intrinsics.areEqual(string, "2")) {
                    list = new ConstraintResolverV2(this).getCyclicNodes();
                } else if (Intrinsics.areEqual(string, "1")) {
                    list = new ConstraintResolver(this).getCyclicNodes();
                } else {
                    String string3 = "Invalid value for \"elementa.dev.cycle_resolver\", falling back to V2 solver.";
                    System.out.println((Object)string3);
                    list = new ConstraintResolverV2(this).getCyclicNodes();
                }
                List<ResolverNode> cyclicNodes = list;
                constraintResolutionGui = new ConstraintResolutionGui(guiName, this, cyclicNodes);
            } else {
                UChat.chat("\u00a7cElementa encountered an error while drawing a GUI. Check your logs for more information.");
                constraintResolutionGui = null;
            }
            UMinecraft.setCurrentScreenObj(constraintResolutionGui);
        }
    }

    public final void drawEmbedded$Elementa(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        super.draw(matrixStack);
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawFloatingComponents(matrixStack)", imports={}))
    public final void drawFloatingComponents() {
        this.drawFloatingComponents(new UMatrixStack());
    }

    public final void drawFloatingComponents(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Iterator<UIComponent> it = this.floatingComponents.iterator();
        while (it.hasNext()) {
            UIComponent component2 = it.next();
            if (Companion.ofOrNull(component2) == null) {
                it.remove();
                continue;
            }
            component2.drawCompat(matrixStack);
        }
    }

    @Override
    public void mouseScroll(double delta) {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Pair<Float, Float> pair = this.getMousePosition();
        float mouseX = ((Number)pair.component1()).floatValue();
        float mouseY = ((Number)pair.component2()).floatValue();
        for (UIComponent floatingComponent : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!floatingComponent.isPointInside(mouseX, mouseY)) continue;
            floatingComponent.mouseScroll(delta);
            return;
        }
        super.mouseScroll(delta);
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int button) {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Pair<Double, Double> pair = this.pixelCoordinatesToPixelCenter$Elementa(mouseX, mouseY);
        double adjustedX = ((Number)pair.component1()).doubleValue();
        double adjustedY = ((Number)pair.component2()).doubleValue();
        this.doMouseClick(adjustedX, adjustedY, button);
    }

    private final void doMouseClick(double mouseX, double mouseY, int button) {
        this.currentMouseButton = button;
        Function3<? super Double, ? super Double, ? super Integer, Boolean> function3 = this.clickInterceptor;
        if (function3 != null) {
            Function3<? super Double, ? super Double, ? super Integer, Boolean> function32;
            Function3<? super Double, ? super Double, ? super Integer, Boolean> it = function32 = function3;
            boolean bl = false;
            if (it.invoke((Double)mouseX, (Double)mouseY, (Integer)button).booleanValue()) {
                return;
            }
        }
        for (UIComponent floatingComponent : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!floatingComponent.isPointInside((float)mouseX, (float)mouseY)) continue;
            floatingComponent.mouseClick(mouseX, mouseY, button);
            this.dealWithFocusRequests();
            return;
        }
        super.mouseClick(mouseX, mouseY, button);
        this.dealWithFocusRequests();
    }

    private final void dealWithFocusRequests() {
        if (this.componentRequestingFocus == null) {
            this.unfocus();
        } else if (!Intrinsics.areEqual(this.componentRequestingFocus, this.focusedComponent)) {
            if (this.focusedComponent != null) {
                UIComponent uIComponent = this.focusedComponent;
                if (uIComponent != null) {
                    uIComponent.loseFocus();
                }
            }
            UIComponent uIComponent = this.focusedComponent = this.componentRequestingFocus;
            if (uIComponent != null) {
                uIComponent.focus();
            }
        }
        this.componentRequestingFocus = null;
    }

    @Override
    public void mouseRelease() {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        super.mouseRelease();
        this.currentMouseButton = -1;
    }

    @Override
    public void keyType(char typedChar, int keyCode) {
        char character;
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        char c = character = CharCategory.PRIVATE_USE.contains(typedChar) ? (char)'\u0000' : typedChar;
        if (this.focusedComponent != null) {
            UIComponent uIComponent = this.focusedComponent;
            if (uIComponent != null) {
                uIComponent.keyType(character, keyCode);
            }
        } else {
            super.keyType(character, keyCode);
        }
    }

    @Override
    public void animationFrame() {
        if (this.currentMouseButton != -1) {
            Pair<Float, Float> pair = this.getMousePosition();
            float mouseX = ((Number)pair.component1()).floatValue();
            float mouseY = ((Number)pair.component2()).floatValue();
            if (this.version.compareTo((Enum)ElementaVersion.Companion.getV2$Elementa()) >= 0) {
                this.dragMouse(mouseX, mouseY, this.currentMouseButton);
            } else {
                this.dragMouse((int)mouseX, (int)mouseY, this.currentMouseButton);
            }
        }
        if (this.componentRequestingFocus != null && !Intrinsics.areEqual(this.componentRequestingFocus, this.focusedComponent)) {
            if (this.focusedComponent != null) {
                UIComponent uIComponent = this.focusedComponent;
                if (uIComponent != null) {
                    uIComponent.loseFocus();
                }
            }
            UIComponent uIComponent = this.focusedComponent = this.componentRequestingFocus;
            if (uIComponent != null) {
                uIComponent.focus();
            }
        }
        this.componentRequestingFocus = null;
        super.animationFrame();
    }

    @Override
    public float getLeft() {
        return 0.0f;
    }

    @Override
    public float getTop() {
        return 0.0f;
    }

    @Override
    public float getWidth() {
        return UResolution.getScaledWidth();
    }

    @Override
    public float getHeight() {
        return UResolution.getScaledHeight();
    }

    @Override
    public float getRight() {
        return this.getWidth();
    }

    @Override
    public float getBottom() {
        return this.getHeight();
    }

    public final boolean isAreaVisible(double left2, double top, double right, double bottom) {
        if (right < (double)this.getLeft() || left2 > (double)this.getRight() || bottom < (double)this.getTop() || top > (double)this.getBottom()) {
            return false;
        }
        ScissorEffect.ScissorState scissorState = ScissorEffect.Companion.getCurrentScissorState();
        if (scissorState == null) {
            return true;
        }
        ScissorEffect.ScissorState currentScissor = scissorState;
        double sf = UResolution.getScaleFactor();
        double realX = (double)currentScissor.getX() / sf;
        double realWidth = (double)currentScissor.getWidth() / sf;
        double bottomY = ((double)UResolution.getScaledHeight() * sf - (double)currentScissor.getY()) / sf;
        double realHeight = (double)currentScissor.getHeight() / sf;
        return right > realX && left2 < realX + realWidth && bottom >= bottomY - realHeight && top <= bottomY;
    }

    public final void addFloatingComponent(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        if (this.floatingComponents.contains(component2)) {
            return;
        }
        this.floatingComponents.add(component2);
    }

    public final void removeFloatingComponent(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        this.floatingComponents.remove(component2);
    }

    @Override
    @NotNull
    public UIComponent hitTest(float x, float y) {
        for (UIComponent component2 : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!component2.isPointInside(x, y)) continue;
            return component2.hitTest(x, y);
        }
        return super.hitTest(x, y);
    }

    public final void focus(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        this.componentRequestingFocus = component2;
    }

    public final void unfocus() {
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        UIComponent uIComponent = this.focusedComponent;
        if (uIComponent != null) {
            uIComponent.loseFocus();
        }
        this.focusedComponent = null;
    }

    @JvmOverloads
    public Window(@NotNull ElementaVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, "version");
        this(version, 0, 2, null);
    }

    @Deprecated(message="Add ElementaVersion as the first argument to opt-in to improved behavior.")
    @JvmOverloads
    public Window() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgg/essential/elementa/components/Window$Companion;", "", "()V", "renderOperations", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Function0;", "", "enqueueRenderOperation", "operation", "Ljava/lang/Runnable;", "of", "Lgg/essential/elementa/components/Window;", "component", "Lgg/essential/elementa/UIComponent;", "ofOrNull", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public final void enqueueRenderOperation(@NotNull Runnable operation) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            renderOperations.add(new Function0<Unit>(operation){
                final /* synthetic */ Runnable $operation;
                {
                    this.$operation = $operation;
                    super(0);
                }

                public final void invoke() {
                    this.$operation.run();
                }
            });
        }

        public final void enqueueRenderOperation(@NotNull Function0<Unit> operation) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            renderOperations.add(operation);
        }

        @NotNull
        public final Window of(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter(component2, "component");
            Window window = this.ofOrNull(component2);
            if (window == null) {
                throw new IllegalStateException("No window parent? It's possible you haven't called Window.addChild() at this point in time.");
            }
            return window;
        }

        @Nullable
        public final Window ofOrNull(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter(component2, "component");
            Window window = component2.getCachedWindow$Elementa();
            if (window == null) {
                Companion companion;
                Companion $this$ofOrNull_u24lambda_u240 = companion = this;
                boolean bl = false;
                UIComponent current = component2;
                while (!(current instanceof Window) && current.getHasParent() && !Intrinsics.areEqual(current.getParent(), current)) {
                    current = current.getParent();
                }
                UIComponent uIComponent = current;
                window = uIComponent instanceof Window ? (Window)uIComponent : null;
            }
            return window;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

